<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Myqueries extends CheckAction {

	/**
	 * List of user's queries
	 */
	public function action_index()
    {
		$user_id = Auth::instance()->get_user()->id;
		$list = ORM::factory('User_Query')
			->where('user_id', '=', $user_id)
			->find_all();
        
        if(isset($_POST['check']) && isset($_POST['remove']) && !empty($_POST['check']) ){
            foreach($_POST['check'] as $id_remove){
                ORM::factory('User_Query', $id_remove)->delete();
            }
            HTTP::redirect('/myqueries/');
        }

		$this->template->content = View::factory('myqueries/v_index')
			->bind('list', $list);
	}

	/**
	 * Edit user's query
	 */
	public function action_editor()
    {
		$user_query_id = $this->request->param('id');

		$filter = ORM::factory('User_Query', $user_query_id);
		if ($filter->loaded())
        {
			$this->checkAccess($user_query_id);
		}

		if (Request::POST == $this->request->method() && null !== $this->request->post('apply'))
        {
            if ( $filter->addOrUpdateQuery($this->request->post(), ! $filter->loaded() ? Auth::instance()->get_user()->id : null) )
            {
    			HTTP::redirect('/myqueries/');
            }
            
            $errors = $filter->getErrors();
		}

        $countAdditionalRows = 0;
        $filter_host = null !== $filter->host ? explode('|', $filter->host) : [];
        $countAdditionalRows = max($countAdditionalRows, count($filter_host) - 1);
        $filter_net = null !== $filter->net ? explode('|', $filter->net) : [];
        $countAdditionalRows = max($countAdditionalRows, count($filter_net) - 1);
        $filter_referrer = null !== $filter->referrer ? explode('|', $filter->referrer) : [];
        $countAdditionalRows = max($countAdditionalRows, count($filter_referrer) - 1);
        $filter_link = null !== $filter->link ? explode('|', $filter->link) : [];
        $countAdditionalRows = max($countAdditionalRows, count($filter_link) - 1);
        $filter_ip = null !== $filter->ip ? explode('|', $filter->ip) : [];
        $countAdditionalRows = max($countAdditionalRows, count($filter_ip) - 1);
        
		$this->template->content = View::factory('myqueries/v_editor')
			->bind('filter', $filter)
            ->bind('countAdditionalRows', $countAdditionalRows)
            ->bind('filter_host', $filter_host)
            ->bind('filter_net', $filter_net)
            ->bind('filter_referrer', $filter_referrer)
            ->bind('filter_link', $filter_link)
            ->bind('filter_ip', $filter_ip)
            ->bind('errors', $errors)
			->bind('id', $user_query_id);
	}

	private function checkAccess($id){
		$list = ORM::factory('User_Query', $id);
		$user_id = Auth::instance()->get_user()->id;
		if($list->user_id != $user_id){
			HTTP::redirect('/myqueries/');
		}
	}
}